<?php
require_once __DIR__ . '/../includes/inc.php';

$action = post('action', get('action'));

if (!is_installed()) {
    json_response(0, '系统未安装，请先安装', array('redirect' => '/install/'));
}

$publicActions = array('login');
if (!in_array($action, $publicActions, true)) {
    require_admin_ajax_login();
}

try {
    switch ($action) {
        case 'login':
            $user = Auth::login(post('username'), post('password'));
            json_response(1, '登录成功', $user);
            break;

        case 'logout':
            Auth::logout();
            json_response(1, '已退出登录');
            break;

        case 'dashboard_stats':
            json_response(1, 'ok', Navigator::dashboardStats());
            break;

        case 'visit_report':
            json_response(1, 'ok', VisitLogger::reportSummary());
            break;

        case 'get_settings':
            json_response(1, 'ok', Navigator::getSettings());
            break;

        case 'save_settings':
            Navigator::saveSettings(array(
                'site_name' => post('site_name'),
                'site_subtitle' => post('site_subtitle'),
                'site_description' => post('site_description'),
                'theme_template' => post('theme_template'),
                'copyright_text' => post('copyright_text'),
                'qq_number' => post('qq_number'),
                'qq_group' => post('qq_group'),
                'snow_enabled' => post('snow_enabled', '0')
            ));
            json_response(1, '保存成功');
            break;

        case 'set_theme':
            Navigator::saveSettings(array(
                'theme_template' => post('theme_template')
            ));
            json_response(1, '模板保存成功');
            break;

        case 'change_password':
            $old = post('old_password');
            $new = post('new_password');
            $new2 = post('new_password2');
            if ($new !== $new2) {
                json_response(0, '两次新密码不一致');
            }
            Auth::changePassword($_SESSION['admin_id'], $old, $new);
            Auth::logout();
            json_response(1, '密码修改成功');
            break;

        case 'nav_list':
            $list = Navigator::listNav(post('keyword'));
            json_response(1, 'ok', array('list' => $list));
            break;

        case 'nav_detail':
            $id = (int)post('id');
            $info = Navigator::getNavById($id);
            if (empty($info)) {
                json_response(0, '记录不存在');
            }
            json_response(1, 'ok', $info);
            break;

        case 'nav_add':
            $id = Navigator::addNav(array(
                'title' => post('title'),
                'url' => post('url'),
                'icon' => post('icon'),
                'icon_type' => post('icon_type', 'font'),
                'description' => post('description'),
                'sort_order' => post('sort_order', 0),
                'is_visible' => post('is_visible', 0)
            ));
            json_response(1, '添加成功', array('id' => $id));
            break;

        case 'nav_edit':
            Navigator::updateNav((int)post('id'), array(
                'title' => post('title'),
                'url' => post('url'),
                'icon' => post('icon'),
                'icon_type' => post('icon_type', 'font'),
                'description' => post('description'),
                'sort_order' => post('sort_order', 0),
                'is_visible' => post('is_visible', 0)
            ));
            json_response(1, '更新成功');
            break;

        case 'nav_delete':
            $rows = Navigator::deleteNav((int)post('id'));
            if ($rows <= 0) {
                json_response(0, '删除失败或记录不存在');
            }
            json_response(1, '删除成功');
            break;

        case 'nav_batch_delete':
            $ids = isset($_POST['ids']) ? $_POST['ids'] : array();
            Navigator::batchDelete($ids);
            json_response(1, '删除成功');
            break;

        case 'upload_image':
            if (!isset($_FILES['image'])) {
                json_response(0, '请上传图片文件');
            }
            $file = $_FILES['image'];
            if ((int)$file['error'] !== 0) {
                json_response(0, '上传失败，错误码：' . $file['error']);
            }
            if ((int)$file['size'] > 2 * 1024 * 1024) {
                json_response(0, '图片不能超过 2MB');
            }

            $ext = strtolower(pathinfo($file['name'], PATHINFO_EXTENSION));
            $allowExt = array('jpg', 'jpeg', 'png', 'gif', 'webp');
            if (!in_array($ext, $allowExt, true)) {
                json_response(0, '仅支持 jpg/jpeg/png/gif/webp');
            }

            if (!ensure_dir(UPLOAD_DIR)) {
                json_response(0, '上传目录不可写');
            }

            $saveName = date('YmdHis') . '_' . mt_rand(1000, 9999) . '.' . $ext;
            $savePath = UPLOAD_DIR . '/' . $saveName;
            if (!move_uploaded_file($file['tmp_name'], $savePath)) {
                json_response(0, '保存文件失败');
            }

            json_response(1, '上传成功', array('url' => UPLOAD_URL_PREFIX . '/' . $saveName));
            break;

        default:
            json_response(0, '未知操作');
    }
} catch (Exception $e) {
    json_response(0, $e->getMessage());
}
