<?php
require_once __DIR__ . '/../includes/inc.php';
require_install_or_redirect();
require_admin_page_login();

$pageTitle = '仪表盘';
$activeMenu = 'dashboard';
require_once __DIR__ . '/head.php';
?>
<div class="card mb-3">
    <div class="card-body">
        <div class="row g-2 align-items-center">
            <div class="col-12 col-md">
                <span class="me-3"><strong>程序官网：</strong><a href="https://gerendaohang.cn" target="_blank" class="text-decoration-none">gerendaohang.cn</a></span>
                <span class="me-3"><strong>程序版本：</strong>1.0</span>
                <span><strong>QQ群：</strong>1084197334</span>
            </div>
            <div class="col-12 col-md-auto">
                <a class="btn btn-sm btn-outline-primary" target="_blank" href="https://qun.qq.com/universal-share/share?ac=1&authKey=Dc13qDaHGQWPZjUiVx6U%2FTvxuB5Zy1f32RKqeGFwRiZmZWEouzGpIMO%2BgluNPEFe&busi_data=eyJncm91cENvZGUiOiIxMDg0MTk3MzM0IiwidG9rZW4iOiJqVld6aElFN3Y0YWpQZnNIc084Z1RFZnErU2Z3Tmk4Zlc5T2tMdlpndk85aFNXWU1OYU1qMFBtclJXQTV5RjlnIiwidWluIjoiOTM3MDU3MDczIn0%3D&data=iCk3Pbzwo27IURN3n3przwV5-jjpD1qgLnL6YY9wzF9a7OQPbLSlxFWmNvFSr0WHqRS2QDWES-PSQXrBaxNndQ&svctype=4&tempid=h5_group_info">加入QQ群</a>
            </div>
        </div>
    </div>
</div>

<div class="row g-3 mb-3" id="statsWrap">
    <div class="col-12 col-md-4">
        <div class="card">
            <div class="card-body">
                <div class="text-secondary small">导航总数</div>
                <div class="fs-2 fw-bold" id="totalCount">0</div>
            </div>
        </div>
    </div>
    <div class="col-12 col-md-4">
        <div class="card">
            <div class="card-body">
                <div class="text-secondary small">前台显示</div>
                <div class="fs-2 fw-bold text-success" id="visibleCount">0</div>
            </div>
        </div>
    </div>
    <div class="col-12 col-md-4">
        <div class="card">
            <div class="card-body">
                <div class="text-secondary small">隐藏数据</div>
                <div class="fs-2 fw-bold text-warning" id="hiddenCount">0</div>
            </div>
        </div>
    </div>
</div>

<div class="card">
    <div class="card-header d-flex justify-content-between align-items-center">
        <span>最近新增</span>
        <a href="/admin/nav_add.php" class="btn btn-sm btn-primary" target="_blank">新增导航</a>
    </div>
    <div class="card-body p-0">
        <div class="table-responsive">
            <table class="table table-hover mb-0">
                <thead>
                <tr>
                    <th class="px-3">ID</th>
                    <th>名称</th>
                    <th>链接</th>
                    <th>时间</th>
                </tr>
                </thead>
                <tbody id="latestBody">
                <tr><td colspan="4" class="text-center text-secondary py-4">加载中...</td></tr>
                </tbody>
            </table>
        </div>
    </div>
</div>

<script>
(function () {
    $.post('/admin/ajax.php', {action: 'dashboard_stats'}, function (res) {
        if (res.code !== 1) {
            layer.msg(res.msg || '加载失败');
            return;
        }

        var d = res.data || {};
        $('#totalCount').text(d.total || 0);
        $('#visibleCount').text(d.visible || 0);
        $('#hiddenCount').text(d.hidden || 0);

        var latest = d.latest || [];
        if (!latest.length) {
            $('#latestBody').html('<tr><td colspan="4" class="text-center text-secondary py-4">暂无数据</td></tr>');
            return;
        }

        var html = '';
        for (var i = 0; i < latest.length; i++) {
            var item = latest[i];
            html += '<tr>' +
                '<td class="px-3">' + item.id + '</td>' +
                '<td>' + $('<div>').text(item.title || '').html() + '</td>' +
                '<td><a href="' + item.url + '" target="_blank" class="text-decoration-none">' + $('<div>').text(item.url || '').html() + '</a></td>' +
                '<td>' + (item.created_at || '') + '</td>' +
                '</tr>';
        }
        $('#latestBody').html(html);
    }, 'json').fail(function () {
        layer.msg('请求失败');
    });
})();
</script>
<?php require_once __DIR__ . '/end.php'; ?>
