<?php
require_once __DIR__ . '/../includes/inc.php';
require_install_or_redirect();
require_admin_page_login();

$pageTitle = '修改密码';
$activeMenu = 'password';
require_once __DIR__ . '/head.php';
?>
<div class="card" style="max-width: 680px;">
    <div class="card-header">修改密码</div>
    <div class="card-body">
        <form id="pwdForm" class="row g-3">
            <div class="col-12">
                <label class="form-label">旧密码</label>
                <input type="password" name="old_password" class="form-control" required>
            </div>
            <div class="col-12">
                <label class="form-label">新密码</label>
                <input type="password" name="new_password" class="form-control" minlength="6" required>
            </div>
            <div class="col-12">
                <label class="form-label">确认新密码</label>
                <input type="password" name="new_password2" class="form-control" minlength="6" required>
            </div>
            <div class="col-12">
                <button type="submit" class="btn btn-primary">确认修改</button>
            </div>
        </form>
    </div>
</div>

<script>
$('#pwdForm').on('submit', function (e) {
    e.preventDefault();
    var formData = {
        action: 'change_password',
        old_password: $(this).find('[name="old_password"]').val(),
        new_password: $(this).find('[name="new_password"]').val(),
        new_password2: $(this).find('[name="new_password2"]').val()
    };

    if (formData.new_password !== formData.new_password2) {
        layer.msg('两次新密码不一致');
        return;
    }

    $.post('/admin/ajax.php', formData, function (res) {
        if (res.code !== 1) {
            layer.msg(res.msg || '修改失败');
            return;
        }
        layer.msg('修改成功，请重新登录');
        setTimeout(function () {
            location.href = '/admin/login.php';
        }, 800);
    }, 'json').fail(function () {
        layer.msg('请求失败');
    });
});
</script>
<?php require_once __DIR__ . '/end.php'; ?>
