<?php
require_once __DIR__ . '/../includes/inc.php';
require_install_or_redirect();
require_admin_page_login();

$pageTitle = '访问报表';
$activeMenu = 'report';
require_once __DIR__ . '/head.php';
?>
<div class="row g-3 mb-3">
    <div class="col-12 col-md-3">
        <div class="card"><div class="card-body"><div class="text-secondary small">今日访问</div><div class="fs-4 fw-bold" id="todayPage">0</div></div></div>
    </div>
    <div class="col-12 col-md-3">
        <div class="card"><div class="card-body"><div class="text-secondary small">今日点击</div><div class="fs-4 fw-bold text-primary" id="todayClick">0</div></div></div>
    </div>
    <div class="col-12 col-md-3">
        <div class="card"><div class="card-body"><div class="text-secondary small">昨日访问</div><div class="fs-4 fw-bold" id="yesPage">0</div></div></div>
    </div>
    <div class="col-12 col-md-3">
        <div class="card"><div class="card-body"><div class="text-secondary small">昨日点击</div><div class="fs-4 fw-bold text-primary" id="yesClick">0</div></div></div>
    </div>
</div>

<div class="card">
    <div class="card-header">今日链接点击排行</div>
    <div class="card-body p-0">
        <div class="table-responsive">
            <table class="table table-striped mb-0">
                <thead>
                <tr>
                    <th class="px-3" width="70">排名</th>
                    <th>链接名称</th>
                    <th>目标地址</th>
                    <th width="120">点击数</th>
                </tr>
                </thead>
                <tbody id="topLinksBody">
                <tr><td colspan="4" class="text-center text-secondary py-4">加载中...</td></tr>
                </tbody>
            </table>
        </div>
    </div>
</div>

<script>
function esc(text) {
    return $('<div>').text(text || '').html();
}

function loadReport() {
    $.post('/admin/ajax.php', {action: 'visit_report'}, function (res) {
        if (res.code !== 1) {
            layer.msg(res.msg || '加载失败');
            return;
        }

        var d = res.data || {};
        var today = d.today || {};
        var yes = d.yesterday || {};

        $('#todayPage').text(today.page_view || 0);
        $('#todayClick').text(today.link_click || 0);
        $('#yesPage').text(yes.page_view || 0);
        $('#yesClick').text(yes.link_click || 0);

        var list = d.today_top_links || [];
        if (!list.length) {
            $('#topLinksBody').html('<tr><td colspan="4" class="text-center text-secondary py-4">今日暂无点击数据</td></tr>');
            return;
        }

        var html = '';
        for (var i = 0; i < list.length; i++) {
            var item = list[i];
            html += '<tr>' +
                '<td class="px-3">' + (i + 1) + '</td>' +
                '<td>' + esc(item.title || ('ID:' + (item.nav_item_id || 0))) + '</td>' +
                '<td><a href="' + esc(item.target_url || '#') + '" target="_blank">' + esc(item.target_url || '-') + '</a></td>' +
                '<td>' + (item.clicks || 0) + '</td>' +
                '</tr>';
        }
        $('#topLinksBody').html(html);
    }, 'json').fail(function () {
        layer.msg('请求失败');
    });
}

loadReport();
</script>
<?php require_once __DIR__ . '/end.php'; ?>
