<?php
require_once __DIR__ . '/../includes/inc.php';
require_install_or_redirect();
require_admin_page_login();

$pageTitle = '系统设置';
$activeMenu = 'settings';
require_once __DIR__ . '/head.php';
?>
<div class="card">
    <div class="card-header">系统设置</div>
    <div class="card-body">
        <form id="settingForm" class="row g-3">
            <div class="col-12 col-md-6">
                <label class="form-label">站点名称</label>
                <input name="site_name" class="form-control" maxlength="60">
            </div>
            <div class="col-12 col-md-6">
                <label class="form-label">站点副标题</label>
                <input name="site_subtitle" class="form-control" maxlength="120">
            </div>
            <div class="col-12">
                <label class="form-label">站点描述</label>
                <textarea name="site_description" class="form-control" rows="2" maxlength="200"></textarea>
            </div>
            <div class="col-12">
                <div class="alert alert-info mb-0">
                    前台模板已拆分到独立页面管理。
                    <a href="/admin/template.php" class="alert-link">点击前往模板选择</a>
                </div>
            </div>
            <div class="col-12 col-md-6">
                <label class="form-label">底部版权文案</label>
                <input name="copyright_text" class="form-control" maxlength="120">
            </div>
            <div class="col-12 col-md-6">
                <label class="form-label d-block">雪花效果</label>
                <div class="form-check form-switch">
                    <input class="form-check-input" type="checkbox" id="snowEnabled">
                    <label class="form-check-label" for="snowEnabled">开启前台雪花特效</label>
                </div>
            </div>
            <div class="col-12 col-md-6">
                <label class="form-label">QQ 号</label>
                <input name="qq_number" class="form-control" maxlength="20" placeholder="可留空">
            </div>
            <div class="col-12 col-md-6">
                <label class="form-label">QQ群号</label>
                <input name="qq_group" class="form-control" maxlength="20" placeholder="可留空">
            </div>
            <div class="col-12">
                <button type="submit" class="btn btn-primary">保存设置</button>
            </div>
        </form>
    </div>
</div>

<script>
function loadSettings() {
    $.post('/admin/ajax.php', {action: 'get_settings'}, function (res) {
        if (res.code !== 1) {
            layer.msg(res.msg || '加载失败');
            return;
        }
        var d = res.data || {};
        $('#settingForm [name="site_name"]').val(d.site_name || '');
        $('#settingForm [name="site_subtitle"]').val(d.site_subtitle || '');
        $('#settingForm [name="site_description"]').val(d.site_description || '');
        $('#settingForm [name="copyright_text"]').val(d.copyright_text || '');
        $('#settingForm [name="qq_number"]').val(d.qq_number || '');
        $('#settingForm [name="qq_group"]').val(d.qq_group || '');
        $('#snowEnabled').prop('checked', (d.snow_enabled || '0') === '1');
    }, 'json');
}

$('#settingForm').on('submit', function (e) {
    e.preventDefault();
    var formData = {
        action: 'save_settings',
        site_name: $.trim($(this).find('[name="site_name"]').val()),
        site_subtitle: $.trim($(this).find('[name="site_subtitle"]').val()),
        site_description: $.trim($(this).find('[name="site_description"]').val()),
        copyright_text: $.trim($(this).find('[name="copyright_text"]').val()),
        qq_number: $.trim($(this).find('[name="qq_number"]').val()),
        qq_group: $.trim($(this).find('[name="qq_group"]').val()),
        snow_enabled: $('#snowEnabled').prop('checked') ? '1' : '0'
    };
    $.post('/admin/ajax.php', formData, function (res) {
        if (res.code !== 1) {
            layer.msg(res.msg || '保存失败');
            return;
        }
        layer.msg('保存成功');
    }, 'json').fail(function () {
        layer.msg('请求失败');
    });
});

loadSettings();
</script>
<?php require_once __DIR__ . '/end.php'; ?>
