<?php
require_once __DIR__ . '/../includes/inc.php';
require_install_or_redirect();
require_admin_page_login();

$pageTitle = '前台模板';
$activeMenu = 'template';
require_once __DIR__ . '/head.php';
?>
<div class="card">
    <div class="card-header d-flex justify-content-between align-items-center">
        <span>前台模板选择</span>
        <a href="/" target="_blank" class="btn btn-sm btn-outline-primary">打开前台</a>
    </div>
    <div class="card-body">
        <div class="row g-3" id="templateWrap">
            <div class="col-12 col-md-6">
                <div class="border rounded-3 p-3 h-100 template-card" data-template="style1">
                    <div class="fw-bold mb-2">style1</div>
                    <div class="small text-secondary mb-3">经典卡片风格</div>
                    <button class="btn btn-sm btn-primary use-theme-btn" data-template="style1">使用该模板</button>
                </div>
            </div>
            <div class="col-12 col-md-6">
                <div class="border rounded-3 p-3 h-100 template-card" data-template="style2">
                    <div class="fw-bold mb-2">style2</div>
                    <div class="small text-secondary mb-3">功能分区风格</div>
                    <button class="btn btn-sm btn-primary use-theme-btn" data-template="style2">使用该模板</button>
                </div>
            </div>
            <div class="col-12 col-md-6">
                <div class="border rounded-3 p-3 h-100 template-card" data-template="style3">
                    <div class="fw-bold mb-2">style3</div>
                    <div class="small text-secondary mb-3">图文网格风格</div>
                    <button class="btn btn-sm btn-primary use-theme-btn" data-template="style3">使用该模板</button>
                </div>
            </div>
            <div class="col-12 col-md-6">
                <div class="border rounded-3 p-3 h-100 template-card" data-template="style15">
                    <div class="fw-bold mb-2">style15</div>
                    <div class="small text-secondary mb-3">个性化渐变风格</div>
                    <button class="btn btn-sm btn-primary use-theme-btn" data-template="style15">使用该模板</button>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
    .template-card { transition: all .2s ease; }
    .template-card.active {
        border-color: #1d4ed8 !important;
        box-shadow: 0 0 0 2px rgba(29, 78, 216, .15);
        background: #f8fbff;
    }
</style>

<script>
function setActiveTemplate(templateName) {
    $('.template-card').removeClass('active');
    $('.template-card[data-template="' + templateName + '"]').addClass('active');
}

function loadCurrentTemplate() {
    $.post('/admin/ajax.php', {action: 'get_settings'}, function (res) {
        if (res.code !== 1) {
            layer.msg(res.msg || '加载失败');
            return;
        }
        var current = (res.data && res.data.theme_template) ? res.data.theme_template : 'style2';
        setActiveTemplate(current);
    }, 'json').fail(function () {
        layer.msg('请求失败');
    });
}

$('.use-theme-btn').on('click', function () {
    var template = $(this).attr('data-template');
    $.post('/admin/ajax.php', {action: 'set_theme', theme_template: template}, function (res) {
        if (res.code !== 1) {
            layer.msg(res.msg || '保存失败');
            return;
        }
        setActiveTemplate(template);
        layer.msg('模板已切换');
    }, 'json').fail(function () {
        layer.msg('请求失败');
    });
});

loadCurrentTemplate();
</script>
<?php require_once __DIR__ . '/end.php'; ?>
