<?php

class Auth
{
    public static function login($username, $password)
    {
        if ($username === "" || $password === "") {
            throw new Exception("账号和密码不能为空");
        }

        $db = Database::getInstance();
        $admin = $db->fetch("SELECT * FROM admins WHERE username = :username LIMIT 1", array("username" => $username));
        if (empty($admin)) {
            throw new Exception("账号或密码错误");
        }

        if (!password_verify($password, $admin["password"])) {
            throw new Exception("账号或密码错误");
        }

        $_SESSION["admin_id"] = (int)$admin["id"];
        $_SESSION["admin_username"] = $admin["username"];
        $_SESSION["login_at"] = time();

        return array(
            "id" => (int)$admin["id"],
            "username" => $admin["username"]
        );
    }

    public static function logout()
    {
        $_SESSION = array();
        if (ini_get("session.use_cookies")) {
            $params = session_get_cookie_params();
            setcookie(session_name(), "", time() - 3600, $params["path"], $params["domain"], $params["secure"], $params["httponly"]);
        }
        session_destroy();
    }

    public static function changePassword($adminId, $oldPassword, $newPassword)
    {
        $adminId = (int)$adminId;
        if ($adminId <= 0) {
            throw new Exception("未登录");
        }
        if ($oldPassword === "" || $newPassword === "") {
            throw new Exception("旧密码和新密码不能为空");
        }
        if (strlen($newPassword) < 6) {
            throw new Exception("新密码至少 6 位");
        }

        $db = Database::getInstance();
        $admin = $db->fetch("SELECT * FROM admins WHERE id = :id LIMIT 1", array("id" => $adminId));
        if (empty($admin)) {
            throw new Exception("账号不存在");
        }

        if (!password_verify($oldPassword, $admin["password"])) {
            throw new Exception("旧密码错误");
        }

        $db->execute(
            "UPDATE admins SET password = :password, updated_at = :updated_at WHERE id = :id",
            array(
                "password" => password_hash($newPassword, PASSWORD_DEFAULT),
                "updated_at" => date("Y-m-d H:i:s"),
                "id" => $adminId
            )
        );

        return true;
    }
}
