<?php

class VisitLogger
{
    private static $tableReady = false;

    public static function logPageView($path)
    {
        self::ensureTable();
        self::insertLog("page_view", 0, (string)$path, "");
    }

    public static function logLinkClick($navItem)
    {
        self::ensureTable();
        $navId = isset($navItem["id"]) ? (int)$navItem["id"] : 0;
        $url = isset($navItem["url"]) ? (string)$navItem["url"] : "";
        self::insertLog("link_click", $navId, "", $url);
    }

    public static function reportSummary()
    {
        self::ensureTable();

        $db = Database::getInstance();
        $today = date("Y-m-d");
        $yesterday = date("Y-m-d", strtotime("-1 day"));

        $todayPage = $db->fetch(
            "SELECT COUNT(*) AS c FROM visit_logs WHERE visit_date = :d AND event_type = 'page_view'",
            array("d" => $today)
        );
        $todayClick = $db->fetch(
            "SELECT COUNT(*) AS c FROM visit_logs WHERE visit_date = :d AND event_type = 'link_click'",
            array("d" => $today)
        );
        $yesPage = $db->fetch(
            "SELECT COUNT(*) AS c FROM visit_logs WHERE visit_date = :d AND event_type = 'page_view'",
            array("d" => $yesterday)
        );
        $yesClick = $db->fetch(
            "SELECT COUNT(*) AS c FROM visit_logs WHERE visit_date = :d AND event_type = 'link_click'",
            array("d" => $yesterday)
        );

        $topLinks = $db->fetchAll(
            "SELECT v.nav_item_id, n.title, v.target_url, COUNT(*) AS clicks
             FROM visit_logs v
             LEFT JOIN nav_items n ON n.id = v.nav_item_id
             WHERE v.visit_date = :d AND v.event_type = 'link_click'
             GROUP BY v.nav_item_id, n.title, v.target_url
             ORDER BY clicks DESC, v.nav_item_id DESC
             LIMIT 10",
            array("d" => $today)
        );

        return array(
            "today" => array(
                "date" => $today,
                "page_view" => (int)$todayPage["c"],
                "link_click" => (int)$todayClick["c"]
            ),
            "yesterday" => array(
                "date" => $yesterday,
                "page_view" => (int)$yesPage["c"],
                "link_click" => (int)$yesClick["c"]
            ),
            "today_top_links" => $topLinks
        );
    }

    private static function ensureTable()
    {
        if (self::$tableReady) {
            return;
        }

        $db = Database::getInstance();
        $db->execute("CREATE TABLE IF NOT EXISTS visit_logs (
            id INTEGER PRIMARY KEY AUTOINCREMENT,
            event_type TEXT NOT NULL,
            nav_item_id INTEGER NOT NULL DEFAULT 0,
            path TEXT NOT NULL DEFAULT '',
            target_url TEXT NOT NULL DEFAULT '',
            ip TEXT NOT NULL DEFAULT '',
            user_agent TEXT NOT NULL DEFAULT '',
            referer TEXT NOT NULL DEFAULT '',
            visit_date TEXT NOT NULL,
            created_at TEXT NOT NULL
        )");
        $db->execute("CREATE INDEX IF NOT EXISTS idx_visit_logs_date_type ON visit_logs(visit_date, event_type)");
        $db->execute("CREATE INDEX IF NOT EXISTS idx_visit_logs_nav ON visit_logs(nav_item_id)");

        self::$tableReady = true;
    }

    private static function insertLog($eventType, $navItemId, $path, $targetUrl)
    {
        $db = Database::getInstance();
        $now = date("Y-m-d H:i:s");
        $db->execute(
            "INSERT INTO visit_logs (event_type, nav_item_id, path, target_url, ip, user_agent, referer, visit_date, created_at)
             VALUES (:event_type, :nav_item_id, :path, :target_url, :ip, :user_agent, :referer, :visit_date, :created_at)",
            array(
                "event_type" => $eventType,
                "nav_item_id" => (int)$navItemId,
                "path" => (string)$path,
                "target_url" => (string)$targetUrl,
                "ip" => client_ip(),
                "user_agent" => isset($_SERVER["HTTP_USER_AGENT"]) ? substr((string)$_SERVER["HTTP_USER_AGENT"], 0, 255) : "",
                "referer" => isset($_SERVER["HTTP_REFERER"]) ? substr((string)$_SERVER["HTTP_REFERER"], 0, 255) : "",
                "visit_date" => date("Y-m-d"),
                "created_at" => $now
            )
        );
    }
}
