<?php
if (!function_exists('tpl_icon_html')) {
    function tpl_icon_html($icon, $title, $fallback, $imgStyle, $iconType)
    {
        $icon = trim((string)$icon);
        $iconType = trim((string)$iconType);
        if ($icon === '') {
            return '<i class="' . e($fallback) . '"></i>';
        }
        if ($iconType === 'image') {
            return '<img src="' . e($icon) . '" alt="' . e($title) . '" style="' . e($imgStyle) . '">';
        }
        if ($iconType !== 'font' && preg_match('#^(https?://|/)#i', $icon)) {
            return '<img src="' . e($icon) . '" alt="' . e($title) . '" style="' . e($imgStyle) . '">';
        }
        return '<i class="' . e($icon) . '"></i>';
    }
}
$siteName = isset($settings['site_name']) ? $settings['site_name'] : '导航页款式 2';
$siteSubtitle = isset($settings['site_subtitle']) ? $settings['site_subtitle'] : '高效工作，快乐生活，一站式访问您的常用资源';
$siteDescription = isset($settings['site_description']) ? $settings['site_description'] : '';
$copyright = isset($settings['copyright_text']) ? $settings['copyright_text'] : '';
$snowEnabled = isset($settings['snow_enabled']) && $settings['snow_enabled'] === '1';
$qqNumber = isset($settings['qq_number']) ? trim($settings['qq_number']) : '';
$qqGroup = isset($settings['qq_group']) ? trim($settings['qq_group']) : '';
$mainLinks = array_slice($links, 0, 4);
$toolLinks = array_slice($links, 4);
$cardBackgrounds = array('var(--primary)', 'var(--purple)', 'var(--orange)', 'var(--blue)');
$toolColors = array('#4c7dfd', '#e74b4b', '#f6a623', '#1abc9c');
?>
<!doctype html>
<html lang="zh-CN">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
    <title><?php echo e($siteName); ?></title>
    <link rel="stylesheet" href="//oss2.myoss.top/assets/libs/fontawesome-free-6.7.2-web/css/all.css">
    <style>
        :root {
            --bg: #f5f6fb;
            --panel: #ffffff;
            --text: #222;
            --muted: #7a7a7a;
            --shadow: 0 22px 45px rgba(0, 0, 0, 0.12);
            --primary: linear-gradient(135deg, #5b67ff, #6a8bff);
            --purple: linear-gradient(135deg, #8a36ff, #6a5dff);
            --orange: linear-gradient(135deg, #f39a3c, #f8681c);
            --blue: linear-gradient(135deg, #4ab0ff, #3778ff);
        }

        * { box-sizing: border-box; }

        body {
            margin: 0;
            min-height: 100vh;
            background: var(--bg);
            font-family: "PingFang SC", "Microsoft YaHei", "Helvetica Neue", Arial, sans-serif;
            color: var(--text);
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 18px;
        }

        .wrap {
            background: var(--panel);
            width: min(460px, 100%);
            border-radius: 18px;
            box-shadow: var(--shadow);
            overflow: hidden;
        }

        .hero {
            padding: 26px 22px 18px;
            background: linear-gradient(180deg, #f5f8ff 0%, #eef3ff 100%);
            text-align: center;
        }

        .hero .icon {
            width: 76px;
            height: 76px;
            border-radius: 50%;
            margin: 0 auto 12px;
            background: var(--primary);
            box-shadow: 0 14px 24px rgba(90, 107, 255, 0.35);
            display: grid;
            place-items: center;
            color: #fff;
            font-size: 30px;
        }

        .hero h1 { margin: 0 0 6px; font-size: 22px; letter-spacing: 0.5px; }
        .hero p { margin: 0; color: var(--muted); font-size: 14px; }

        .notice {
            margin: 12px 18px 16px;
            border: 1px dashed #f3b35a;
            border-radius: 6px;
            padding: 10px 12px;
            background: #fff8ed;
            color: #c87c1b;
            font-size: 13px;
            line-height: 1.5;
        }

        .section { padding: 0 16px 18px; }
        .section h2 { display: flex; align-items: center; gap: 8px; font-size: 16px; margin: 0 0 12px; }

        .grid-2 { display: grid; grid-template-columns: repeat(2, minmax(0, 1fr)); gap: 12px; }

        .card {
            padding: 14px 12px;
            border-radius: 12px;
            color: #fff;
            position: relative;
            overflow: hidden;
            box-shadow: 0 14px 24px rgba(0, 0, 0, 0.12);
            min-height: 88px;
            text-decoration: none;
        }

        .card .title { font-size: 16px; margin: 0 0 6px; font-weight: 700; }
        .card .desc { font-size: 13px; opacity: 0.92; margin: 0; }

        .card .badge {
            position: absolute;
            right: 12px;
            top: 12px;
            width: 36px;
            height: 36px;
            border-radius: 10px;
            background: rgba(255, 255, 255, 0.22);
            display: grid;
            place-items: center;
            color: #fff;
            font-size: 16px;
        }

        .tools { display: grid; grid-template-columns: repeat(2, minmax(0, 1fr)); gap: 10px; }

        .tool {
            background: #f8f9ff;
            border-radius: 12px;
            padding: 18px 14px 14px;
            text-align: center;
            box-shadow: 0 10px 18px rgba(0, 0, 0, 0.08);
            text-decoration: none;
            color: #444;
        }

        .tool .ticon {
            width: 44px;
            height: 44px;
            border-radius: 12px;
            margin: 0 auto 8px;
            display: grid;
            place-items: center;
            color: #fff;
            font-size: 18px;
        }

        .tool p { margin: 0; font-size: 14px; }

        .contact { margin-top: 10px; font-size: 12px; color: #8a8a8a; line-height: 1.7; }
        .contact a { color: #5b67ff; text-decoration: none; }

        #snowCanvas { position: fixed; inset: 0; z-index: 9999; pointer-events: none; }

        @media (max-width: 420px) {
            .grid-2, .tools { grid-template-columns: 1fr; }
            .card { min-height: 82px; }
        }
    </style>
</head>
<body>
<div class="wrap">
    <div class="hero">
        <div class="icon"><i class="fa-solid fa-compass"></i></div>
        <h1><?php echo e($siteName); ?></h1>
        <p><?php echo e($siteSubtitle); ?></p>
    </div>
    <div class="notice"><?php echo e($siteDescription !== '' ? $siteDescription : '欢迎访问，请从下方快速进入常用站点。'); ?></div>

    <div class="section">
        <h2><i class="fa-solid fa-arrow-up"></i>主要功能</h2>
        <div class="grid-2">
            <?php if (empty($mainLinks)): ?>
                <a class="card" href="javascript:void(0)" style="background: var(--primary);">
                    <p class="title">暂无导航</p>
                    <p class="desc">请先到后台添加链接</p>
                </a>
            <?php else: ?>
                <?php foreach ($mainLinks as $idx => $item): ?>
                    <a class="card" href="<?php echo e(front_nav_href($item)); ?>" target="_blank" style="background: <?php echo e($cardBackgrounds[$idx % count($cardBackgrounds)]); ?>;">
                        <div class="badge"><?php echo tpl_icon_html($item['icon'], $item['title'], 'fa-solid fa-link', 'width:18px;height:18px;border-radius:4px;object-fit:cover;display:block;', isset($item['icon_type']) ? $item['icon_type'] : ''); ?></div>
                        <p class="title"><?php echo e($item['title']); ?></p>
                        <p class="desc"><?php echo e($item['description']); ?></p>
                    </a>
                <?php endforeach; ?>
            <?php endif; ?>
        </div>
    </div>

    <div class="section" style="padding-bottom: 22px;">
        <h2><i class="fa-solid fa-toolbox"></i>常用工具</h2>
        <div class="tools">
            <?php if (empty($toolLinks)): ?>
                <?php foreach ($mainLinks as $idx => $item): ?>
                    <a class="tool" href="<?php echo e(front_nav_href($item)); ?>" target="_blank">
                        <div class="ticon" style="background:<?php echo e($toolColors[$idx % count($toolColors)]); ?>;"><?php echo tpl_icon_html($item['icon'], $item['title'], 'fa-solid fa-star', 'width:22px;height:22px;border-radius:6px;object-fit:cover;display:block;', isset($item['icon_type']) ? $item['icon_type'] : ''); ?></div>
                        <p><?php echo e($item['title']); ?></p>
                    </a>
                <?php endforeach; ?>
            <?php else: ?>
                <?php foreach ($toolLinks as $idx => $item): ?>
                    <a class="tool" href="<?php echo e(front_nav_href($item)); ?>" target="_blank">
                        <div class="ticon" style="background:<?php echo e($toolColors[$idx % count($toolColors)]); ?>;"><?php echo tpl_icon_html($item['icon'], $item['title'], 'fa-solid fa-star', 'width:22px;height:22px;border-radius:6px;object-fit:cover;display:block;', isset($item['icon_type']) ? $item['icon_type'] : ''); ?></div>
                        <p><?php echo e($item['title']); ?></p>
                    </a>
                <?php endforeach; ?>
            <?php endif; ?>
        </div>
        <div class="contact">
            <?php if ($qqNumber !== '' || $qqGroup !== ''): ?>
                QQ：<?php echo e($qqNumber !== '' ? $qqNumber : '未设置'); ?>
                <?php if ($qqGroup !== ''): ?> | 群：<?php echo e($qqGroup); ?><?php endif; ?>
                <br>
            <?php endif; ?>
            <?php if ($copyright !== ''): ?><?php echo e($copyright); ?><?php endif; ?>
        </div>
    </div>
</div>

<?php if ($snowEnabled): ?>
<canvas id="snowCanvas"></canvas>
<script>
(function () {
    var canvas = document.getElementById('snowCanvas');
    if (!canvas) return;
    var ctx = canvas.getContext('2d');
    var flakes = [];
    var count = 90;
    function resize() { canvas.width = window.innerWidth; canvas.height = window.innerHeight; }
    function reset(f) {
        f.x = Math.random() * canvas.width;
        f.y = Math.random() * canvas.height;
        f.r = 1 + Math.random() * 3;
        f.vx = -0.4 + Math.random() * 0.8;
        f.vy = 0.8 + Math.random() * 1.6;
    }
    for (var i = 0; i < count; i++) { var f = {}; reset(f); flakes.push(f); }
    function draw() {
        ctx.clearRect(0, 0, canvas.width, canvas.height);
        ctx.fillStyle = 'rgba(255,255,255,0.85)';
        for (var i = 0; i < flakes.length; i++) {
            var f = flakes[i];
            f.x += f.vx;
            f.y += f.vy;
            if (f.y > canvas.height || f.x < -20 || f.x > canvas.width + 20) { reset(f); f.y = -10; }
            ctx.beginPath(); ctx.arc(f.x, f.y, f.r, 0, Math.PI * 2); ctx.fill();
        }
        requestAnimationFrame(draw);
    }
    window.addEventListener('resize', resize); resize(); draw();
})();
</script>
<?php endif; ?>
</body>
</html>
