<?php
if (!function_exists('tpl_icon_html')) {
    function tpl_icon_html($icon, $title, $fallback, $imgStyle, $iconType)
    {
        $icon = trim((string)$icon);
        $iconType = trim((string)$iconType);
        if ($icon === '') {
            return '<i class="' . e($fallback) . '"></i>';
        }
        if ($iconType === 'image') {
            return '<img src="' . e($icon) . '" alt="' . e($title) . '" style="' . e($imgStyle) . '">';
        }
        if ($iconType !== 'font' && preg_match('#^(https?://|/)#i', $icon)) {
            return '<img src="' . e($icon) . '" alt="' . e($title) . '" style="' . e($imgStyle) . '">';
        }
        return '<i class="' . e($icon) . '"></i>';
    }
}
$siteName = isset($settings['site_name']) ? $settings['site_name'] : '导航页款式 3';
$siteSubtitle = isset($settings['site_subtitle']) ? $settings['site_subtitle'] : '灵感引导页，快捷访问您的常用资源';
$siteDescription = isset($settings['site_description']) ? $settings['site_description'] : '';
$copyright = isset($settings['copyright_text']) ? $settings['copyright_text'] : '';
$snowEnabled = isset($settings['snow_enabled']) && $settings['snow_enabled'] === '1';
$qqNumber = isset($settings['qq_number']) ? trim($settings['qq_number']) : '';
$qqGroup = isset($settings['qq_group']) ? trim($settings['qq_group']) : '';
$quickLinks = array_slice($links, 0, 2);
$gridLinks = array_slice($links, 2);
$bannerUrl = 'https://placehold.co/1000x380';
$avatarUrl = 'https://placehold.co/200x200';
?>
<!doctype html>
<html lang="zh-CN">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
    <title><?php echo e($siteName); ?></title>
    <link rel="stylesheet" href="//oss2.myoss.top/assets/libs/fontawesome-free-6.7.2-web/css/all.css">
    <style>
        :root {
            --bg: #f7f1f5;
            --card: #ffffff;
            --text: #1f1f1f;
            --muted: #8a8a8a;
            --shadow: 0 18px 32px rgba(0, 0, 0, 0.12);
        }

        * { box-sizing: border-box; }

        body {
            margin: 0;
            min-height: 100vh;
            background: var(--bg);
            font-family: "PingFang SC", "Microsoft YaHei", "Helvetica Neue", Arial, sans-serif;
            color: var(--text);
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 12px;
        }

        .wrap {
            width: min(440px, 100%);
            background: var(--card);
            border-radius: 16px;
            overflow: hidden;
            box-shadow: var(--shadow);
        }

        .hero { position: relative; height: 170px; background: #ddd; }
        .hero img { width: 100%; height: 100%; object-fit: cover; display: block; }

        .avatar {
            position: absolute;
            left: 50%;
            bottom: -36px;
            transform: translateX(-50%);
            width: 96px;
            height: 96px;
            border-radius: 50%;
            border: 6px solid #fff;
            overflow: hidden;
            box-shadow: 0 14px 24px rgba(0, 0, 0, 0.18);
            background: #fff;
        }

        .avatar img { width: 100%; height: 100%; object-fit: cover; display: block; }

        .heading { padding: 50px 16px 18px; text-align: center; }
        .heading h1 { margin: 0 0 6px; font-size: 22px; }
        .heading p { margin: 0; font-size: 13px; color: var(--muted); }

        .quick {
            display: grid;
            grid-template-columns: repeat(2, minmax(0, 1fr));
            gap: 12px;
            padding: 0 16px 16px;
        }

        .quick a {
            display: grid;
            grid-template-columns: 42px 1fr;
            align-items: center;
            gap: 10px;
            background: #fff;
            border-radius: 14px;
            padding: 10px 12px;
            box-shadow: 0 10px 18px rgba(0, 0, 0, 0.08);
            text-decoration: none;
            color: #444;
        }

        .quick .icon {
            width: 42px;
            height: 42px;
            border-radius: 50%;
            background: #f3f6ff;
            display: grid;
            place-items: center;
            color: #8c9eff;
            font-size: 16px;
            overflow: hidden;
        }

        .quick .text { display: flex; flex-direction: column; gap: 2px; }
        .quick .text .title { font-weight: 700; font-size: 14px; }
        .quick .text .desc { font-size: 12px; color: var(--muted); }

        .grid {
            display: grid;
            grid-template-columns: repeat(2, minmax(0, 1fr));
            gap: 12px;
            padding: 0 16px 18px;
        }

        .cell {
            background: #fff;
            border-radius: 14px;
            padding: 14px 12px;
            display: grid;
            grid-template-columns: 44px 1fr;
            align-items: center;
            gap: 12px;
            box-shadow: 0 12px 20px rgba(0, 0, 0, 0.08);
            text-decoration: none;
            color: #444;
        }

        .cell .pic {
            width: 44px;
            height: 44px;
            border-radius: 10px;
            overflow: hidden;
            background: #f3f3f3;
            display: grid;
            place-items: center;
            color: #6b7280;
            font-size: 17px;
        }

        .cell .pic img { width: 100%; height: 100%; object-fit: cover; display: block; }

        .cell .meta { display: flex; flex-direction: column; gap: 4px; }
        .cell .meta .title { font-weight: 700; font-size: 15px; }
        .cell .meta .desc { font-size: 12px; color: var(--muted); }

        .contact {
            padding: 0 16px 18px;
            text-align: center;
            font-size: 12px;
            color: #8a8a8a;
            line-height: 1.7;
        }
        .contact a { color: #6f7dff; text-decoration: none; }

        #snowCanvas { position: fixed; inset: 0; z-index: 9999; pointer-events: none; }

        @media (max-width: 420px) {
            .quick, .grid { grid-template-columns: 1fr; }
            .heading h1 { font-size: 20px; }
        }
    </style>
</head>
<body>
<div class="wrap">
    <div class="hero">
        <img src="<?php echo e($bannerUrl); ?>" alt="顶部图片">
        <div class="avatar"><img src="<?php echo e($avatarUrl); ?>" alt="头像"></div>
    </div>

    <div class="heading">
        <h1><?php echo e($siteName); ?></h1>
        <p><?php echo e($siteSubtitle); ?></p>
    </div>

    <div class="quick">
        <?php if (empty($quickLinks)): ?>
            <a href="javascript:void(0)">
                <div class="icon"><i class="fa-solid fa-link"></i></div>
                <div class="text"><span class="title">暂无链接</span><span class="desc">请到后台添加</span></div>
            </a>
        <?php else: ?>
            <?php foreach ($quickLinks as $item): ?>
                <a href="<?php echo e(front_nav_href($item)); ?>" target="_blank">
                    <div class="icon"><?php echo tpl_icon_html($item['icon'], $item['title'], 'fa-solid fa-compass', 'width:100%;height:100%;object-fit:cover;display:block;', isset($item['icon_type']) ? $item['icon_type'] : ''); ?></div>
                    <div class="text">
                        <span class="title"><?php echo e($item['title']); ?></span>
                        <span class="desc"><?php echo e($item['description']); ?></span>
                    </div>
                </a>
            <?php endforeach; ?>
        <?php endif; ?>
    </div>

    <div class="grid">
        <?php if (empty($gridLinks)): ?>
            <?php foreach ($quickLinks as $item): ?>
                <a class="cell" href="<?php echo e(front_nav_href($item)); ?>" target="_blank">
                    <div class="pic"><?php echo tpl_icon_html($item['icon'], $item['title'], 'fa-solid fa-star', 'width:100%;height:100%;object-fit:cover;display:block;', isset($item['icon_type']) ? $item['icon_type'] : ''); ?></div>
                    <div class="meta">
                        <span class="title"><?php echo e($item['title']); ?></span>
                        <span class="desc"><?php echo e($item['description']); ?></span>
                    </div>
                </a>
            <?php endforeach; ?>
        <?php else: ?>
            <?php foreach ($gridLinks as $item): ?>
                <a class="cell" href="<?php echo e(front_nav_href($item)); ?>" target="_blank">
                    <div class="pic"><?php echo tpl_icon_html($item['icon'], $item['title'], 'fa-solid fa-globe', 'width:100%;height:100%;object-fit:cover;display:block;', isset($item['icon_type']) ? $item['icon_type'] : ''); ?></div>
                    <div class="meta">
                        <span class="title"><?php echo e($item['title']); ?></span>
                        <span class="desc"><?php echo e($item['description']); ?></span>
                    </div>
                </a>
            <?php endforeach; ?>
        <?php endif; ?>
    </div>

    <div class="contact">
        <?php echo e($siteDescription); ?>
        <?php if ($qqNumber !== '' || $qqGroup !== ''): ?>
            <br>QQ：<?php echo e($qqNumber !== '' ? $qqNumber : '未设置'); ?>
            <?php if ($qqGroup !== ''): ?> | 群：<?php echo e($qqGroup); ?><?php endif; ?>
        <?php endif; ?>
        <?php if ($copyright !== ''): ?><br><?php echo e($copyright); ?><?php endif; ?>
    </div>
</div>

<?php if ($snowEnabled): ?>
<canvas id="snowCanvas"></canvas>
<script>
(function () {
    var canvas = document.getElementById('snowCanvas');
    if (!canvas) return;
    var ctx = canvas.getContext('2d');
    var flakes = [];
    var count = 90;
    function resize() { canvas.width = window.innerWidth; canvas.height = window.innerHeight; }
    function reset(f) {
        f.x = Math.random() * canvas.width;
        f.y = Math.random() * canvas.height;
        f.r = 1 + Math.random() * 3;
        f.vx = -0.4 + Math.random() * 0.8;
        f.vy = 0.8 + Math.random() * 1.6;
    }
    for (var i = 0; i < count; i++) { var f = {}; reset(f); flakes.push(f); }
    function draw() {
        ctx.clearRect(0, 0, canvas.width, canvas.height);
        ctx.fillStyle = 'rgba(255,255,255,0.85)';
        for (var i = 0; i < flakes.length; i++) {
            var f = flakes[i];
            f.x += f.vx;
            f.y += f.vy;
            if (f.y > canvas.height || f.x < -20 || f.x > canvas.width + 20) { reset(f); f.y = -10; }
            ctx.beginPath(); ctx.arc(f.x, f.y, f.r, 0, Math.PI * 2); ctx.fill();
        }
        requestAnimationFrame(draw);
    }
    window.addEventListener('resize', resize); resize(); draw();
})();
</script>
<?php endif; ?>
</body>
</html>
